Attribute VB_Name = "modCommandsCustom"
Public Type COMMANDTYPE
    ctCommand As String
    ctLevel As Integer
    ctResponse As String
End Type

Public CustComm() As COMMANDTYPE

Public Function AddCommand(Cmd As String, Level As Integer, Response As String) As Boolean
On Error GoTo hErr:
    Dim I As Integer
1   I = FindCommand(Cmd)
2   If I > -1 Then AddCommand = False: Exit Function
    Dim C As COMMANDTYPE
3   C.ctCommand = Cmd
4   C.ctLevel = Level
5   C.ctResponse = Response
6   If LenB(CustComm(0).ctCommand) Then ReDim Preserve CustComm(UBound(CustComm) + 1)
7   CustComm(UBound(CustComm)) = C
    AddCommand = True
    Exit Function
hErr:
    ErrorHandler Err.Description, Erl, "CustomCommands", "AddCommand"
End Function

Public Function FindCommand(Cmd As String) As Integer
On Error GoTo hErr:
    Dim I As Integer
1   For I = 0 To UBound(CustComm)
2       If LCase$(CustComm(I).ctCommand) = LCase$(Cmd) Then
3           FindCommand = I
            Exit Function
        End If
    Next I
    FindCommand = -1
    Exit Function
hErr:
    FindCommand = -1
    ErrorHandler Err.Description, Erl, "CustomCommands", "FindCommand"
End Function

Public Function RemoveCommand(Cmd As String) As Boolean
    Dim I As Integer
1   I = FindCommand(Cmd)
    RemoveCommand = False
    If I = -1 Then Exit Function
2   If UBound(CustComm) > 0 Then
        Dim X As Integer
3       For X = I To UBound(CustComm) - 1
4           CustComm(X) = CustComm(X + 1)
5       Next X
6       ReDim Preserve CustComm(UBound(CustComm) - 1)
    Else
7       ReDim CustComm(0)
    End If
    RemoveCommand = True
    Exit Function
hErr:
    RemoveCommand = False
    ErrorHandler Err.Description, Erl, "CustomCommands", "RemoveCommand"
End Function

Public Sub SaveCommands()
On Error Resume Next
    Dim F As String, FF As Integer
    FF = FreeFile
    F = AppData & "Commands.ini"
    Open F For Append As #FF: Close #FF
    Open F For Output As #FF
    Dim I As Integer
    For I = 0 To UBound(CustComm)
        Print #FF, CustComm(I).ctCommand & "#" & CustComm(I).ctLevel & "#"; CustComm(I).ctResponse
    Next I
    Close #FF
End Sub

Public Sub LoadCommands()
On Error GoTo hErr:
1   ReDim CustComm(0)
2   Dim FSO As New FileSystemObject, TS As TextStream
3   Set TS = FSO.OpenTextFile(AppData & "Commands.ini", ForReading, True)
4   Do Until TS.AtEndOfStream
        Dim LN As String
5       LN = TS.ReadLine()
6       If InStrB(LN, "#") Then
            Dim SP() As String
7           SP = Split(LN, "#", 3)
8           If UBound(SP) = 2 Then
9               AddCommand SP(0), CInt(Val(SP(1))), SP(2)
            End If
        End If
    Loop
10  TS.Close
    Exit Sub
hErr:
    ErrorHandler Err.Description, Erl, "CustomCommands", "LoadCommands"
End Sub

Public Function HandleCustomCommand(CS As COMMANDSTRUCT) As Boolean
On Error GoTo hErr:
    If LenB(CS.Message) = 0 Then Exit Function
    Dim C() As String, I As Integer, B As BNCS
1   C() = Split(CS.Message, " ", 2)
    If LenB(C(0)) = 0 Then Exit Function
2   Set B = frmBot.Bot(CS.Index)
3   For I = 0 To UBound(CustComm)
4       If LCase$(CustComm(I).ctCommand) = LCase$(C(0)) Then
5           HandleCustomCommand = True
6           If Not B Is Nothing Then
7               Dim R As clsDatabaseUser, RankN As String, Level As Integer, U As clsUser, L As clsClanMember, v As Integer, CR As String
8               Set L = B.Clan.GetByName(CS.Username)
                If Not L Is Nothing Then CR = ClanRankToString(CByte(Val(L.Rank)))
9               Set R = B.Database.GetUser(B.Database.Find(CS.Username))
10              Set U = B.Users.GetByName(CS.Username)
11              If Not R Is Nothing Then
                    Level = GetRankByID(R.RankID).Plugin
                    RankN = GetRankByID(R.RankID).RankName
                Else
                    Level = 0
                    RankN = vbNullString
                End If
12              If Level >= CustComm(I).ctLevel Then
                    Dim T As String
13                  T = CustComm(I).ctResponse
14                  T = Replace$(T, "%0", B.GetAccount(CS.Username))
15                  T = Replace$(T, "%a", CR)
16                  T = Replace$(T, "%d", Date)
17                  T = Replace$(T, "%e", GetServerName(B.Config.Server))
18                  T = Replace$(T, "%h", B.Self.Channel)
19                  T = Replace$(T, "%r", RankN)
20                  T = Replace$(T, "%t", Time)
21                  T = Replace$(T, "%u", B.Self.Username)
22                  T = Replace$(T, "%v", "MirageBot " & App.Major & "." & App.Minor)
                    If UBound(C) = 1 Then
                        If InStr(C(1), " ") > 0 Then
                            Dim nv As Integer, rest As String
                            parts = Split(C(1), " ")
                            For v = 0 To UBound(parts)
                               If InStrB(T, "%" & v + 1) Then nv = v + 1: T = Replace$(T, "%" & v + 1, parts(v))
                            Next
                            For v = nv To UBound(parts)
                                rest = rest & parts(v) & " "
                            Next
                            If LenB(rest) Then
                                rest = Left$(rest, Len(rest) - 1)
                                T = Replace$(T, "%z", rest)
                            End If
                        ElseIf LenB(C(1)) Then
                            T = Replace$(T, "%1", C(1))
                            T = Replace$(T, "%z", C(1))
                        End If
                    End If
23                  If Not U Is Nothing Then
24                      T = Replace$(T, "%c", GetClanName(U.Statstring))
25                      T = Replace$(T, "%f", LongToHex(U.Flags))
26                      T = Replace$(T, "%p", U.Ping)
27                      T = Replace$(T, "%g", GetClientName(StrReverse$(Left$(U.Statstring, 4))))
28                      T = Replace$(T, "%s", GetClientStats(U.Statstring))
                    Else
                        T = Replace$(T, "%c", vbNullString)
                        T = Replace$(T, "%f", vbNullString)
                        T = Replace$(T, "%p", vbNullString)
                        T = Replace$(T, "%g", vbNullString)
                        T = Replace$(T, "%s", vbNullString)
                    End If
                    Dim CS2 As COMMANDSTRUCT
                    If InStr(T, ";") > 0 Then
                        Dim P As Integer, Semi() As String
                        Semi = Split(T, ";")
                        For P = 0 To UBound(Semi)
                            If Left$(Semi(P), 1) = "/" Then
                                If Mid$(Semi(P), 2) = "/" Then
                                '
                                Else
                                    CS2 = CS
                                    CS2.Message = Trim$(Mid$(Semi(P), 2))
                                    If HandleCommand(CS2) Then
                                        '
                                    Else
29                                      frmBot.Bot(CS.Index).SendText LTrim$(CS2.Message)
                                    End If
                                End If
                            Else
                                frmBot.Bot(CS.Index).SendText LTrim$(Semi(P))
                            End If
                        Next P
                    Else
                        If Left$(T, 1) = "/" Then
                            If Mid$(T, 2) = "/" Then
                            '
                            Else
                                CS2 = CS
                                CS2.Message = Trim$(Mid$(T, 2))
                                If HandleCommand(CS2) Then
                                    '
                                Else
                                    frmBot.Bot(CS.Index).SendText LTrim$(CS2.Message)
                                End If
                            End If
                        Else
                            frmBot.Bot(CS.Index).SendText LTrim$(T)
                        End If
                    End If
                End If
            End If
            Exit For
        End If
    Next
    Exit Function
hErr:
    ErrorHandler Err.Description, Erl, "CustomCommands", "HandleCommand"
End Function
